﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Xml;
using System.Text;
using demo.common;

namespace demo.xml
{
    /// <summary>
    ///  接收xml请求和url请求
    /// </summary>
    public partial class server : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.RequestType == "POST")
            {
                // 定义接收xml数据
                string xml;
                using (Stream MyStream = Request.InputStream)
                {
                    // 获取请求xml的文件流
                    byte[] _tmpData = new byte[MyStream.Length];
                    MyStream.Read(_tmpData, 0, _tmpData.Length);
                    xml = Encoding.UTF8.GetString(_tmpData);

                    //写日志
                    myUntil until = new myUntil();
                    until.log(Server, xml);
                }

               // 默认请求返回的内容
               string xmlResult = @"<?xml version=""1.0"" encoding=""UTF-8"" ?><response><statuscode>400</statuscode><statusmsg>未解析该请求</statusmsg></response>";

               // 解析xml文件
                try
                {
                    //声明一个XMLDoc文档对象，LOAD（）xml字符串  
                    XmlDocument doc = new XmlDocument();
                    doc.LoadXml(xml);
                    //得到XML文档根节点  
                    XmlElement root = doc.DocumentElement;
                    if (root.Name == "request")
                    {
                        XmlNodeList nls = root.ChildNodes;
                        foreach (XmlNode xn1 in nls)
                        {
                            XmlElement valueElement = (XmlElement)xn1;
                            if (valueElement.Name == "action")
                            {
                                string action = valueElement.InnerText;
                                if (action == "CallAuth")
                                {
                                    //解析呼叫鉴权
                                    xmlResult = parseCallAuth(nls);
                                }
                                else if (action == "CallEstablish")
                                {
                                    //解析摘机请求
                                    xmlResult = parseCallEstablish(nls);
                                }
                                else if (action == "Hangup")
                                {
                                    //解析挂断请求
                                    xmlResult = parseHangup(nls);
                                }
                                break;
                            }
                        }
                    }
                } 
                finally 
                {

                }

                // 此处可以把自己定义的xml文件返回到调用者
                Response.Write(xmlResult);
                Response.End(); // 结束输出
            }
        }

        private string parseCallAuth(XmlNodeList nodelist)
        {
            CallAuthen info = new CallAuthen();
            foreach (XmlNode xn1 in nodelist)
            {
                XmlElement valueElement = (XmlElement)xn1;
                if (valueElement.Name == "type")
                {
                    info.type = valueElement.InnerText;
                }
                if (valueElement.Name == "orderid")
                {
                    info.orderId = valueElement.InnerText;
                }
                if (valueElement.Name == "subid")
                {
                    info.subId = valueElement.InnerText;
                }
                if (valueElement.Name == "caller")
                {
                    info.caller = valueElement.InnerText;
                }
                if (valueElement.Name == "called")
                {
                    info.called = valueElement.InnerText;
                }
                if (valueElement.Name == "subtype")
                {
                    info.subType = valueElement.InnerText;
                }
                if (valueElement.Name == "callSid")
                {
                    info.callSid = valueElement.InnerText;
                }
            }
            
            //返回的数据
            StringBuilder retStr = new StringBuilder();
            retStr.Append(@"<?xml version=""1.0"" encoding=""UTF-8"" ?><Response>");

            // 必选字段 状态码 0000表示成功 
            retStr.Append("<statuscode>").Append("0000").Append("</statuscode>");

            // 可选字段 状态描述 
            retStr.Append("<statusmsg>").Append("Success").Append("</statusmsg>");

            // 可选字段 是否录音 0:不录音 1:录音
            retStr.Append("<record>").Append("0").Append("</record>");

            // 可选字段 此次通话时长单位为秒 默认1小时（小于等于0，默认1小时）
            retStr.Append("<sessiontime>").Append("0").Append("</sessiontime>");

            retStr.Append("</Response>");
            return retStr.ToString();
        }

        private string parseCallEstablish(XmlNodeList nodelist)
        {            
            CallEstablish info = new CallEstablish();
            foreach (XmlNode xn1 in nodelist)
            {
                XmlElement valueElement = (XmlElement)xn1;
                if (valueElement.Name == "type")
                {
                    info.type = valueElement.InnerText;
                }
                if (valueElement.Name == "orderid")
                {
                    info.orderId = valueElement.InnerText;
                }
                if (valueElement.Name == "subid")
                {
                    info.subId = valueElement.InnerText;
                }
                if (valueElement.Name == "caller")
                {
                    info.caller = valueElement.InnerText;
                }
                if (valueElement.Name == "called")
                {
                    info.called = valueElement.InnerText;
                }
                if (valueElement.Name == "subtype")
                {
                    info.subType = valueElement.InnerText;
                }
                if (valueElement.Name == "callSid")
                {
                    info.callSid = valueElement.InnerText;
                }
            }

            //返回的数据
            StringBuilder retStr = new StringBuilder();
            retStr.Append(@"<?xml version=""1.0"" encoding=""UTF-8"" ?><Response>");

            // 必选字段 状态码 0000表示成功 
            retStr.Append("<statuscode>").Append("0000").Append("</statuscode>");

            // 可选字段 状态描述 
            retStr.Append("<statusmsg>").Append("Success").Append("</statusmsg>");

            // 必选字段 此次通话时长单位为秒,如鉴权接口返回通话时长以鉴权接口返回为准 默认1小时（小于等于0，默认1小时）
            retStr.Append("<sessiontime>").Append("0").Append("</sessiontime>");

            // 必选字段 呼叫的计费私有数据,挂机时原样传回给第三方
            retStr.Append("<billdata>").Append("计费私有数据").Append("</billdata>");

            retStr.Append("</Response>");
            return retStr.ToString();
        }

        private string parseHangup(XmlNodeList nodelist)
        {
            CallHangup info = new CallHangup();
            foreach (XmlNode xn1 in nodelist)
            {
                XmlElement valueElement = (XmlElement)xn1;
                if (valueElement.Name == "type")
                {
                    info.type = valueElement.InnerText;
                }
                if (valueElement.Name == "orderid")
                {
                    info.orderId = valueElement.InnerText;
                }
                if (valueElement.Name == "subid")
                {
                    info.subId = valueElement.InnerText;
                }
                if (valueElement.Name == "caller")
                {
                    info.caller = valueElement.InnerText;
                }
                if (valueElement.Name == "called")
                {
                    info.called = valueElement.InnerText;
                }
                if (valueElement.Name == "byetype")
                {
                    info.byeType = valueElement.InnerText;
                }
                if (valueElement.Name == "starttime")
                {
                    info.starttime = valueElement.InnerText;
                }
                if (valueElement.Name == "endtime")
                {
                    info.endtime = valueElement.InnerText;
                }
                if (valueElement.Name == "billdata")
                {
                    info.billdata = valueElement.InnerText;
                }
                if (valueElement.Name == "subtype")
                {
                    info.subType = valueElement.InnerText;
                }
                if (valueElement.Name == "callSid")
                {
                    info.callSid = valueElement.InnerText;
                }
                if (valueElement.Name == "recordurl")
                {
                    info.recordUrl = valueElement.InnerText;
                }
            }            

            //返回的数据
            StringBuilder retStr = new StringBuilder();
            retStr.Append(@"<?xml version=""1.0"" encoding=""UTF-8"" ?><Response>");

            // 必选字段 状态码 0000表示成功 
            retStr.Append("<statuscode>").Append("0000").Append("</statuscode>");

            // 可选字段 状态描述 
            retStr.Append("<statusmsg>").Append("Success").Append("</statusmsg>");

            // 可选字段 本次通话消费 单位：元
            retStr.Append("<totalfee>").Append("0.120000").Append("</totalfee>");

            retStr.Append("</Response>");
            return retStr.ToString();
        }
    }
}